/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.screen.render.overlay;

import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.config.PatcherConfig;
import gg.essential.api.EssentialAPI;
import gg.essential.api.utils.Multithreading;
import gg.essential.api.utils.TrustedHostsUtil;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ImagePreview {
    private final Minecraft mc = Minecraft.func_71410_x();
    private BufferedImage image;
    private String loaded;
    private int tex = -1;
    private int width = 100;
    private int height = 100;

    @SubscribeEvent
    public void renderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !PatcherConfig.imagePreview) {
            return;
        }
        ITextComponent chatComponent = this.mc.field_71456_v.func_146158_b().func_146236_a(Mouse.getX(), Mouse.getY());
        if (chatComponent != null) {
            Style chatStyle = chatComponent.func_150256_b();
            ClickEvent chatClickEvent = chatStyle.func_150235_h();
            if (chatStyle.func_150235_h() != null && chatClickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                this.handle(chatClickEvent.func_150668_b());
            }
        }
    }

    private void handle(String value) {
        try {
            URL url = new URL(value);
            String host = url.getHost();
            boolean found = false;
            block2: for (TrustedHostsUtil.TrustedHost trustedHost : EssentialAPI.getTrustedHostsUtil().getTrustedHosts()) {
                for (String domain : trustedHost.getDomains()) {
                    if (!host.equalsIgnoreCase(domain)) continue;
                    found = true;
                    continue block2;
                }
            }
            if (!found) {
                return;
            }
        }
        catch (MalformedURLException e) {
            return;
        }
        if (!value.startsWith("http")) {
            if (this.tex != -1) {
                GlStateManager.func_179150_h((int)this.tex);
            }
            this.tex = -1;
            return;
        }
        if (value.contains("imgur.com/")) {
            String[] split = value.split("/");
            value = String.format("https://i.imgur.com/%s.png", split[split.length - 1]);
        }
        if (!value.equals(this.loaded)) {
            this.loaded = value;
            if (this.tex != -1) {
                GlStateManager.func_179150_h((int)this.tex);
            }
            this.tex = -1;
            String finalValue = value;
            Multithreading.runAsync(() -> this.loadUrl(finalValue));
        }
        if (this.image != null) {
            DynamicTexture dynamicTexture = new DynamicTexture(this.image);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            dynamicTexture.func_110564_a();
            this.tex = dynamicTexture.func_110552_b();
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.image = null;
        }
        if (this.tex != -1) {
            float maxWidth;
            float height;
            GlStateManager.func_179094_E();
            ScaledResolution scaledResolution = new ScaledResolution(this.mc);
            int scaleFactor = scaledResolution.func_78325_e();
            float i = 1.0f / (float)scaleFactor;
            GlStateManager.func_179152_a((float)i, (float)i, (float)i);
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)this.tex);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float aspectRatio = (float)this.width / (float)this.height;
            float scaleWidth = scaledResolution.func_78326_a() * scaleFactor;
            if (!Keyboard.isKeyDown((int)42)) {
                scaleWidth *= PatcherConfig.imagePreviewWidth;
            }
            if (Keyboard.isKeyDown((int)29)) {
                scaleWidth = this.width;
            }
            if ((height = (maxWidth = scaleWidth) / aspectRatio) > (float)(scaledResolution.func_78328_b() * scaleFactor)) {
                height = scaledResolution.func_78328_b() * scaleFactor;
                maxWidth = height * aspectRatio;
            }
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            this.drawTexturedModalRect(0, 0, (int)maxWidth, (int)height);
            GlStateManager.func_179121_F();
        }
    }

    public void drawTexturedModalRect(int x, int y, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUrl(String url) {
        HttpURLConnection connection = null;
        try {
            URL u = new URL(url);
            connection = (HttpURLConnection)u.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(true);
            connection.addRequestProperty("User-Agent", "Patcher Image Previewer");
            connection.setReadTimeout(15000);
            connection.setConnectTimeout(15000);
            connection.setDoOutput(true);
            try (InputStream stream = connection.getInputStream();){
                this.image = TextureUtil.func_177053_a((InputStream)stream);
            }
        }
        catch (Exception e) {
            Patcher.instance.getLogger().error("Failed to load an image preview from {}", (Object)url, (Object)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

